![[Pasted image 20250413190240.png]]

#### Functionality
- Acts as the first hop in enterprise email infrastructure.
- Serves as an enterprise gateway accepting emails from the internet and relaying them to mail servers, POP/IMAP servers, or other MTAs.
- Accepts SMTP messages from internal servers for relay to the internet.
- Typically placed in the DMZ of the network.

### Deployment and Configuration

##### Placement
- Deployed between the firewall and the local email server.
- Can be installed in various ways but typically sits between the firewall and internal email servers.
##### Listeners
- Use listeners to manage incoming SMTP connections.
- Listeners are configured on specific IP interfaces to accept and relay emails.
##### Public Listener
- Handles incoming email connections from external hosts.
- Tags messages for antispam, antivirus, and Outbreak Filter checks.
- Accepts email for specified local domains only.
##### Private Listener
- Manages outgoing email from internal mail servers to external hosts.
- Configures to relay connections from internal hosts with antivirus scanning.

#### Interface Configuration
- Models support multiple interfaces, with higher-level models having more options.
- Allows segregation of internal and external networks using different listeners.
- Supports IPv4 and IPv6 addresses.

### Listener Types

##### Public Listener (Incoming Email)
- Receives connections from external hosts.
- Accepts connections based on HAT settings.
- Uses RAT to verify local domains and relay messages.
##### Private Listener (Outgoing Email)
- Connects to internal mail servers.
- Accepts connections based on HAT settings for outbound traffic.
- Applies antivirus scans by default.

### Deployment Scenarios

##### Single Interface Deployment
- Simple setup using one public listener for inbound and outbound SMTP connections.
- Typically uses the Data 1 interface.
- IP address configured for initial setup; can be managed on Data 1 or Data 2.
##### Two Interface Deployment
- Recommended for more complex enterprise environments.
- Uses separate public and private listeners on different interfaces.
- Public listener handles external connections; private listener manages internal traffic.

### Network Integration

##### MX Records
- Public MX records must point to the Gateway's public IP.
- Ensures the appliance is the destination for incoming organizational emails.
#### Security Considerations
- Placed in the DMZ for controlled exposure to the internet.
- Must be the first hop to accurately determine sender IP and apply filtering.

